require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);

DebugOut("ChoosePlayer");

function ShowSubmitOptions( show )
    EnableWindow( "delete", show )
    EnableWindow( "chooseok", show )
    EnableWindow( "editname", show )
end

function ShowCreateOptions( show )
    EnableWindow( "newplayer", show )
end

function UpdatePlayerChoices( curUser, numUsers, userTable )

    if (numUsers >= kMaxUsers) then
        ShowCreateOptions(false)
    else
        ShowCreateOptions(true)
    end

    if (numUsers==0) then
        ShowSubmitOptions( false )
    else
        ShowSubmitOptions( true )
    end

    for i = 0,numUsers-1 do
        SetLabel( "button_text"..i, userTable[ i+1 ] );
        EnableWindow( "button"..i, true ) ;
    end

    for i = numUsers, kMaxUsers do
        EnableWindow( "button"..i, false ) ;
    end

    if numUsers>0 then
        SetButtonToggleState( "button"..curUser, true );
    end

    DebugOut("UpdatePlayerChoices");
end

ButtonX = kCenter;
ButtonY = 100;
ButtonYSpace = 30;

kMaxUsers = 10

--gSelected = -1 ;

function AddButtons( N )

    t = {
        SetStyle(CreateRadioButtonStyle(NameButtonGraphics, DefaultButtonSound)), 
        BeginGroup(),
    };

    for i = 0,N-1 do
        table.insert(t,
            Button{
                name="button"..i,
                command=function() gSelected = i; end,
                x=ButtonX,
                y=ButtonY+(ButtonYSpace*i),
                
                -- don't forget to change "UpdatePlayerChoices()" when adding shadows
                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                Text
                {
                    name="button_text"..i,
                    label="#name",
                }
            }
        );	
    end

    return Group(t);
end

MakeDialog
{
    -- Name the modal dialog
    name="chooseplayer",
    Bitmap
    { 
        image="ui/surfaces/largedialog",
        x=kCenter,
        y=kCenter,
        
        ChoosePlayerWindow
        {
            x = 0, y = 0, w=kMax, h=kMax,
            
			SetStyle(CreateTextStyle(FontGame, 30, RedColor)),
			Text
			{
				name = "selectaplayer",
				x=190,y=13,w=kMax,h=30,
				flags = kVAlignCenter + kHAlignLeft,
				label= "selectaplayer",
			};

            AddButtons( kMaxUsers );
            
            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                x=100,
                y=400,
                name="editname",
                command =
                    function()
                        gEnterNameValue = GetSelectedPlayerName();
                        name = DoModal("scripts/entername.lua");
                        if (not(name == nil)) then
                            SetCurrentUser(GetCurrentSelectedUser());
                            ChangeCurrentUserName(name);
                            SetPlayerChoices();
                            SetWelcomeName();
                        end
                    end,
			    SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
			    CreateText(2,2,"editname", 0, 0),
			    SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
			    CreateText(0,0,"editname", 0, 0),
            };

            Button
            {
                x=260,
                y=445,
                name="chooseok",
                default = true,
                command = 
                    function()
                        if (UserChanged()) then
                            SetCurrentUser(GetCurrentSelectedUser());
                        end
                        
                        SetWelcomeName();
                        PlaySound("audio/sfx/menu/switch_screen.ogg");
                        PopModal("chooseplayer");
                    end,
                SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
                CreateText(2,2,"ok", 0, 0),
                SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
                CreateText(0,0,"ok", 0, 0),
            };
                
            Button
            {
                x=260,
                y=400,
                name="newplayer",
                command =
                    function()
                        gEnterNameValue = "";
                        name = DoModal("scripts/entername.lua");
                        if (not(name == nil)) then
                            CreateNewUser(name);
                            SetPlayerChoices()
                        end
                    end,
                SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
                CreateText(2,2,"newplayer", 0, 0),
                SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
                CreateText(0,0,"newplayer", 0, 0),
            };
                
            Button
            {
                x=100,
                y=445,
                name="delete",
                command =
                    function()
                        result = DisplayDialog { 
                            "scripts/yesno.lua", 
                            body ="deleteconfirm",
                            title = "deletetitle"
                        };
                        if (result=='yes') then
                            DeleteUser(GetCurrentSelectedUser())
                            SetPlayerChoices()
                        end
                    end,
                SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
                CreateText(2,2,"deleteplayer", 0, 0),
                SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
                CreateText(0,0,"deleteplayer", 0, 0),
            };
        }
    }
}


--UpdatePlayerChoices( 0,0, {} );

--SetPlayerChoices();

